/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.editor.json.JSONSourceViewerConfiguration;
import com.aptana.editor.json.internal.text.JSONFoldingComputer;
import com.aptana.editor.json.outline.JSONOutlineContentProvider;
import com.aptana.editor.json.outline.JSONOutlineLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class JSONEditor
extends AbstractThemeableEditor {
    public ITreeContentProvider getOutlineContentProvider() {
        return new JSONOutlineContentProvider();
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new JSONOutlineLabelProvider();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(JSONEditor.getChainedPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JSONSourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(JSONPlugin.getDefault().getJSONDocumentProvider());
    }

    public static IPreferenceStore getChainedPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{JSONPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new JSONFoldingComputer(this, document);
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return JSONPlugin.getDefault().getPreferenceStore();
    }

    public String getContentType() {
        return "com.aptana.contenttype.json";
    }
}

